#include <iostream>
#include <fstream>
#include <iomanip>

int main(int argc, char** argv) {
  using namespace std;

  if (argc != 3) {
    cerr << "Usage:\n  " << argv[0] << " <in file> <out file>\n";
    return 1;
  }

  ifstream in(argv[1]);
  ofstream out(argv[2]);

  if (!in) {
    cerr << "Could not open \"" << argv[2] << "\" for input.\n";
    return 1;
  }
  if (!out) {
    cerr << "Could not open \"" << argv[3] << "\" for output.\n";
    return 1;
  }

  //unsigned count(0);
  while (in) {
    unsigned val(0);
    for (unsigned i = 0; i < 8; ++i) {
      bool got_bit, bit;
      do {
        if (!in) {
          bit = false; got_bit = true;
        } else {
          char c;
          in >> c;
          if      (c ==  '_') { bit = false; got_bit = true; }
          else if (c ==  'X') { bit = true;  got_bit = true; }
          else if (c == '\'') { got_bit = false; while (in.get() != '\n'); }
          else                              got_bit = false;
        }
      } while (!got_bit);
      //cerr << (bit?'X':'_');
      if (bit) val += (1<<i);
    }
    //cerr << endl;
    //if (++count == 8) { count = 0; cerr << endl; }
    if (!!in) out << hex << setw(2) << setfill('0') << val << endl;
  }

  return 0;
}
