module top();
  reg phi, togclk;

  wire hsync, vsync;
  wire [11:0] dac_vid;

  wire strobe;
  wire [6:0] text;   
   
  textgen tgen(phi, strobe, text);
  vgacont vcon(phi, strobe, text, dac_vid, hsync, vsync); 

  initial
    begin
       $dumpfile("dump.vcd");
       $dumpvars(1, top);
       phi = 0; togclk = 0;
       #9 togclk = 1;
       #99991 $finish;
    end

   always
     begin
       #5 phi = phi ^ togclk;
     end
endmodule // top
