#include <iostream>
#include <fstream>

#include <chdl/netlist.h>
#include <chdl/opt.h>
#include <chdl/sim.h>

#include <chdl/tap.h>

#include <chdl/gateops.h>
#include <chdl/bvec-basic-op.h>
#include <chdl/adder.h>
#include <chdl/mult.h>
#include <chdl/mux.h>
#include <chdl/shifter.h>

#include <chdl/memory.h>
#include <chdl/llmem.h>
#include <chdl/input.h>
#include <chdl/analysis.h>

using namespace chdl;
using namespace std;

void textgen(bvec<7> &out, node &cwr) {
  const unsigned DIV(20), TXTLEN(1823), TXTSZ(CLOG2(TXTLEN));
  bvec<DIV> ctr;
  ctr = Reg(ctr + Lit<DIV>(1));

  cwr = ctr == Lit<DIV>(0);

  bvec<TXTSZ> addr;
  addr = Reg(Mux(cwr,
                   addr, Mux(addr == Lit<TXTSZ>(TXTLEN-1),
			     addr + Lit<TXTSZ>(1), Lit<TXTSZ>(0))));
  out = LLRom<TXTSZ, 7>(addr, "text.hex");
}

int main(int argc, char** argv) {
  bvec<7> text; node cwr;
  textgen(text, cwr);
  OUTPUT(text);
  tap("strobe", cwr, true);

  optimize();

  cout << "Critical path: " << critpath() << endl;

  ofstream verilog_out("textgen.v");
  print_verilog("textgen", verilog_out);

  return 0;
}
